import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;

// Referenced classes of package duggelz.jape:
//            InsetPanel

public class OptionDialog extends Dialog
{

    public OptionDialog(Frame parent, Object message, String title, int optionType, int messageType)
    {
        super(parent, title, true);
        value = -1;
        this.optionType = optionType;
        this.messageType = messageType;
        value = -1;
        Panel body = new Panel();
        body.setLayout(new BorderLayout());
        add(body);
        Panel textPanel = new InsetPanel(5, 5, 5, 5);
        textPanel.setLayout(new GridLayout(0, 1));
        textPanel.setBackground(SystemColor.text);
        String messageStr = message.toString();
        Label label;
        for(StringTokenizer st = new StringTokenizer(messageStr, "\n"); st.hasMoreTokens(); textPanel.add(label))
        {
            String line = st.nextToken();
            label = new Label(line, 0);
        }

        Panel buttonPanel = new InsetPanel(0, 5, 0, 5);
        buttonPanel.setLayout(new FlowLayout());
        if(this.optionType == -1 || this.optionType == 2)
        {
            Button button = new Button("OK");
            button.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e)
                {
                    setValue(0);
                }

            });
            buttonPanel.add(button);
        }
        if(this.optionType == 0 || this.optionType == 1)
        {
            Button button = new Button("Ja");
            button.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e)
                {
                    setValue(0);
                }

            });
            buttonPanel.add(button);
        }
        if(this.optionType == 0 || this.optionType == 1)
        {
            Button button = new Button("Nein");
            button.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e)
                {
                    setValue(1);
                }

            });
            buttonPanel.add(button);
        }
        if(this.optionType == 2 || this.optionType == 1)
        {
            Button button = new Button("Abbrechen");
            button.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e)
                {
                    setValue(2);
                }

            });
            buttonPanel.add(button);
        }
        body.add(buttonPanel, "South");
        body.add(textPanel, "Center");
        addWindowListener(new WindowAdapter() {

            public void windowClosing(WindowEvent e)
            {
                dispose();
            }

        });
        addNotify();
        pack();
        if(parent != null)
        {
            Point parentLoc = parent.getLocation();
            Dimension parentSize = parent.getSize();
            Dimension size = getSize();
            Point loc = new Point(parentLoc.x + (parentSize.width - size.width) / 2, parentLoc.y + (parentSize.height - size.height) / 2);
            setLocation(loc);
        }
    }

    public int getValue()
    {
        return value;
    }

    public void setValue(int value)
    {
        this.value = value;
        dispose();
    }

    public static int showConfirmDialog(Frame parent, Object message, String title, int optionType, int messageType)
    {
        OptionDialog dialog = new OptionDialog(parent, message, title, optionType, messageType);
        dialog.show();
        return dialog.getValue();
    }

    public static void showMessageDialog(Frame parent, Object message, String title, int messageType)
    {
        OptionDialog dialog = new OptionDialog(parent, message, title, -1, messageType);
        dialog.show();
    }

    public static final int DEFAULT_OPTION = -1;
    public static final int OK_ONLY_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int CLOSED_OPTION = -1;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    private int optionType;
    private int messageType;
    private int value;
}